%{
#include <math.h>  /* For math functions, cos(), sin(), etc. */
#include <ctype.h>
#include <stdio.h>

/* Data type for links in the chain of symbols.      */

struct symrec
{
  char *name;  /* name of symbol                     */
  int type;    /* type of symbol: either VAR or FNCT */
  union {
    double var;           /* value of a VAR          */    
  } value;
  struct symrec *next;    /* link field              */
};

typedef struct symrec symrec;

/* The symbol table: a chain of `struct symrec'.     */
symrec *sym_table;
symrec *putsym ();
symrec *getsym ();

%}


%union {
int     val;  /* For returning numbers.                   */
char  *varname;   /* For returning symbol-table pointers      */
}



%token <val>  NUM        /* Simple double precision number   */
%token <varname> VAR   /* Variable and Function            */
%type  <val>  exp


%token  PLUS    MINUS   TIMES   DIVIDE  EQUAL PRINTEXP
%token  LEFT_PARENTHESIS RIGHT_PARENTHESIS SETEXP
%token  END

%left   PLUS    MINUS   
%left   TIMES   DIVIDE
%left   NEG
%right  EQUAL 

/* Grammar follows */

%%
input:   /* empty */
        | input line
;

line:
          END 
        | SETEXP VAR EQUAL exp END
			{
				symrec *s;			
				s = getsym ($2);
				if (s == 0)		
					s = putsym ($2, VAR);										
				s->value.var = $4;
			}
        | PRINTEXP exp END   { printf ("%ld\n", $2); }                
;

exp:      NUM                { $$ = $1;                         }
        | VAR                
			{
				symrec *s;			
				s = getsym ($1);
				$$ = s->value.var;              
			}                
        | exp PLUS exp        { $$ = $1 + $3;                    }
        | exp MINUS exp        { $$ = $1 - $3;                    }
        | exp TIMES exp        { $$ = $1 * $3;                    }
        | exp DIVIDE exp        { $$ = $1 / $3;                    }
        | MINUS exp  %prec NEG { $$ = -$2;                        }        
        | LEFT_PARENTHESIS exp RIGHT_PARENTHESIS        { $$ = $2;                         }        
;
/* End of grammar */
%%

yyerror (s)  /* Called by yyparse on error */
     char *s;
{
  printf ("%s\n", s);
}

symrec *
putsym (sym_name,sym_type)
     char *sym_name;
     int sym_type;
{
  symrec *ptr;
  ptr = (symrec *) malloc (sizeof (symrec));
  ptr->name = (char *) malloc (strlen (sym_name) + 1);
  strcpy (ptr->name,sym_name);
  ptr->type = sym_type;
  ptr->value.var = 0; /* set value to 0 even if fctn.  */
  ptr->next = (struct symrec *)sym_table;
  sym_table = ptr;
  return ptr;
}


symrec *
getsym (sym_name)
     char *sym_name;
{
  symrec *ptr;
  for (ptr = sym_table; ptr != (symrec *) 0;
       ptr = (symrec *)ptr->next)
    if (strcmp (ptr->name,sym_name) == 0)
      return ptr;
  return 0;
}

main ()
{
  yyparse ();
}
