%{
#include <stdio.h>
#include "skalk.tab.h"

%}

DIG		[1-9][0-9]*|0
ZMIENNA	[A-Za-z][A-Za-z0-9]*

%%

"+"           return(PLUS);
"-"           return(MINUS);
"*"           return(TIMES);
"/"           return(DIVIDE);
"("           return(LEFT_PARENTHESIS);
")"           return(RIGHT_PARENTHESIS);
"="           return(EQUAL);
"\n"		  return(END);
"PRINT"		  return(PRINTEXP);
"SET"		  return(SETEXP);

{DIG}  {
			yylval.val = atoi(yytext);			
			return NUM;      
		  }		  
{ZMIENNA} {	
			/*symrec *s;			
			s = getsym (yytext);
			if (s == 0)		
				s = putsym (yytext, VAR);		
			yylval.tptr = s;*/
			yylval.varname = (char *) malloc (strlen (yytext) + 1);
			strcpy (yylval.varname,yytext);
			return VAR;
		  }
[ \t\n] {}

. {}

%%



