//
// Simple Lighting Model
// Copyright (c) Microsoft Corporation. All rights reserved.
//
// Note: This effect file works with EffectEdit.
//


float3 listenerPos;

// texture
texture Triangle1Data;
texture Triangle2Data;
texture Triangle3Data;
texture BeamData;
texture SourceData;

// transformations
float4x4 World      : WORLD;
float4x4 View       : VIEW;
float4x4 Projection : PROJECTION;

struct VS_OUTPUT
{
    float4 Pos  : POSITION;    
    float2 Tex : TEXCOORD0;    
};

VS_OUTPUT VS(
    float3 Pos  : POSITION, 
    float3 Norm : NORMAL, 
    float2 Tex  : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;

    
    float4x4 WorldView = mul(World, View);        
    float3 P = mul(Pos, WorldView);    
    Out.Pos  = mul(float4(P, 1), Projection);              // position (projected)
    //Out.Diff = float4(1,0,0,0); // diffuse + ambient
    Out.Tex = Tex;
    return Out;
}

sampler Sampler1 = sampler_state
{
    Texture   = (Triangle1Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler Sampler2 = sampler_state
{
    Texture   = (Triangle2Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler Sampler3 = sampler_state
{
    Texture   = (Triangle3Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler Sampler4 = sampler_state
{
    Texture   = (BeamData);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler Sampler5 = sampler_state
{
    Texture   = (SourceData);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};



const float EPSILON = 0.00001f;

float4 intersect(
    float3 orig,
    float3 v0,
    float3 v1,
    float3 v2)
{
    float3 dir = orig - listenerPos;
    dir=normalize(dir);
    orig = listenerPos;
    float t,u,v;
    bool intersection = true;
    
    float3 edge1, edge2, tvec, pvec, qvec;
    float det;
    float inv_det;

    edge1 = v1 - v0;
    edge2 = v2 - v0;
    
    pvec = cross(dir, edge2);
    det = dot(edge1, pvec);
    if ( det > -EPSILON && det < EPSILON)
        intersection = false;

    inv_det = 1.0 / det;

    tvec = orig - v0;    

    u = dot ( tvec, pvec) * inv_det;
    if ( u < 0.0 || u > 1.0)
        intersection = false;

    qvec = cross( tvec, edge1);
    v = dot(dir, qvec) * inv_det;

    if ( v < 0.0 || u + v > 1.0 )
        intersection = false;
    
    t = dot(edge2, qvec) * inv_det;

    float4 ret_val = float4(0.0, 0.0, 0.0, 0.0);

    if ( intersection ) ret_val = float4(t,u,v,1.0);

    return ret_val;
}

const float TextureDim;// = 128.0f;
const float off;// = 1.0f/128.0f;
const float bias;// = 0.5f/128.0f;

float2 getOff(int pos)
{
    float2 res;
    res.x = floor(pos / TextureDim); 
    res.y = pos - res.x*TextureDim;
    res =  res * off + bias;
    return res.yx;
}

float4 PS(    
    float2 Tex : TEXCOORD0
   ) : COLOR
{   

    float4 triOffset = tex2D(Sampler5, Tex); // .z - face number .y - beam number
    //clip((float4)triOffset.w);

    //vertexy trojkata
    float2 triPos = getOff(triOffset.x);
    float4 v0 = tex2D(Sampler1,triPos );
    float4 v1 = tex2D(Sampler2,triPos );
    float4 v2 = tex2D(Sampler3,triPos );

    float2 srcPos = getOff(triOffset.y);
    //zrodlo dzwieku dla tego beama
    float4 v3 = tex2D(Sampler4,srcPos );
        
    float4 res1 =  intersect(v3,v0,v1,v2);
    
	//float4 ff = tex2D(Sampler1,Tex);
	//return ff;
	
			
	//return float4(1, 0, 0, 0);
    return float4(0.1f,//triOffset.z,  //beam number
				  res1.w, //intersection result
  			      triOffset.z, 0);
}

technique TVertexAndPixelShader
{
    pass P0
    {
        // shaders
        VertexShader = compile vs_2_0 VS();
        PixelShader  = compile ps_2_0 PS();
    }  
}
