/*
 * BFS.java
 *
 * Created on 5 grudzie 2003, 10:11
 */

package AGR.plugins;
import AGR.*;
import java.util.*;
import java.io.*;

/**
 *
 * @author  x
 */
public class BFS implements Plugin {
    
    Graph m_graph;
    LinkedList m_queue = new LinkedList();
    int m_stepCount;
    int m_currentStepCount;
    boolean m_finished;
    /** Creates a new instance of BFS */
    public BFS()
    {
        setStartStep();
    }
    
    int count = 0;
    public void start(final Graph graph, final Vertex startVert) {                
        count = 0;
        m_graph = graph;
        m_finished=false;
        new Thread(){
            public void run() {                                                
                setName("BFS thread");
                while (true){                    
                    m_queue.clear();
                    if(startVert==null)
                        visit(graph.findVertex(0));                        
                    else
                        visit(startVert);
                    if (!m_finished && m_currentStepCount > m_stepCount)
                    {
                        m_currentStepCount = 0;                        
                        m_graph.zeroVertexValues();
                    }
                    else
                    {
                        m_finished=true;
                        return;                    
                    }
                }
            }
        }.start();
    }
    
    public void makeStep() {
        
    }
        
    protected void visit(Vertex start) {
        
        m_queue.add(start);
        Vertex k;
        start.setValue(-1);
              
        while(!m_queue.isEmpty()) {
            if(m_finished) return;
            k = (Vertex)m_queue.removeFirst();
            MainWindow.printToConsole("\nBFS visits: "+k.getId());
            k.setValue(1);      
            k.setFloatVar("k", count);
            count++;
            if ( k.edges!=null )
                for (int i=0; i<k.edges.length; i++) {
                    Edge eg = m_graph.findEdge(k.edges[i]);
                    Vertex vert = m_graph.findVertex(eg.to);
                    if ( vert.getValue() == 0) {
                        vert.setValue(-1);
                        m_queue.add(vert);
                    }
                }
            
            if ( k.edges!=null ){
                /////////////
                m_currentStepCount++;
                while(true) {
                    synchronized (this) {
                        if(m_currentStepCount < m_stepCount)
                            break;
                        if(m_currentStepCount > m_stepCount)
                            return;
                    }
                    try {
                        Thread.sleep(100);
                    } catch(InterruptedException e)
                    { e.printStackTrace(); }
                }
            }
            /////////////
        }
        m_finished=true;
    }

    public String toString()
    {
        return "BFS";
    }
    
    public void setStartStep()
    {
        m_currentStepCount = 0 ;        
        m_stepCount = 1;
        m_finished=true;
        if(m_graph!=null)
            m_graph.zeroVertexValues();
    }        
    
    public boolean isFinished()
    {
        return m_finished;
    }
    public void incStep()
    {
        m_stepCount++;
    }
    public void decStep()
    {
        if (m_stepCount>1)
            m_stepCount--;
    }
     public boolean canDoForward()
    {
        return true;
    }
    public boolean canDoBackward()
    {
        return true;
    }
    public boolean canPause()
    {
        return true;
    }

}


