/*
 * GraphView.java
 *
 * Created on 7 listopad 2003, 08:49
 */

package AGR;

import java.awt.geom.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * @author  x
 */
public class GraphView extends JPanel implements MouseMotionListener, MouseListener {
    
    /** Creates a new instance of GraphView */
    private Graph m_graph;
    final int NODE_DIM_HEIGHT=30;
    final int NODE_DIM_WIDTH=80;
    
    Vertex m_lastVertexClicked;
    Vertex m_lastVertexOver;
    Point m_lastMousePos=new Point();
    Point m_mouseOffsetInVertex = new Point();
    Edge m_lastEdgeOver;
    
    public GraphView() {
        addMouseMotionListener(this);
        addMouseListener(this);
    }
    
    public boolean m_doRelax;
    
    public void setGraph(Graph gr) {
        m_graph = gr;
        
        new Thread(){
            public void run() {
                while(true) {
                    
                    try{
                        if (m_doRelax) {
                            sleep(10);
                        }
                        else
                            sleep(250);
                    } catch(InterruptedException e)
                    {}
                    
                    synchronized(this) {
                        if (m_doRelax) {
                            m_graph.relaxVerticePositions();
                            repaint();
                        }                        
                    }
                }
                
            }
        }.start();
    }
    int no=0;
    public void paint(Graphics g) {
        //if(m_graph!=null)
        //            m_graph.relaxVerticePositions();
        Dimension dim = getSize();
        g.setColor(Color.CYAN);
        g.fillRect(0,0,dim.width,dim.height);
        g.setColor(Color.BLACK);
        int cnt=0;
        
        //ponizsza maciez przechowuje dla kazdego wierzcholka, liczbe krawedzi ktora
        // prowadzi od niego do kazdego innego wierzcholka
        Hashtable edgeCount = new Hashtable();
        
        m_lastEdgeOver=null;
        if (m_graph!=null) {
            Iterator it = m_graph.vertices.iterator();
            while (it.hasNext()) {
                Vertex nd = (Vertex)it.next();
                if ( nd.edges == null ) continue;
                edgeCount.clear();
                for (int e=0; e<nd.edges.length; e++) {
                    Vertex n2=null;
                    Edge currentEdge = m_graph.findEdge(nd.edges[e]);
                    
                    //znajdz wierzcholek docelowy dla tej krawedzi
                    int count = currentEdge.to;
                                       
                    n2 = m_graph.findVertex(count);
                    
                    if(n2 == null){
                        throw new Error("Vertex have assigned null edge");                        
                    }
                    
                    //zliczaj wierzcholki do ktorych ten Vertex wskazuje
                    if ( edgeCount.containsKey(n2) ) {
                        Integer intg = (Integer)edgeCount.get(n2);
                        edgeCount.put(n2, new Integer(intg.intValue()+1));
                    }
                    else
                        edgeCount.put(n2, new Integer(1));
                    
                    //znajdz czy to nie jest kolejna krawedz od wierz. nd do wierz. n2
                    int targetVertexCount=0;
                    targetVertexCount = ((Integer)edgeCount.get(n2)).intValue()-1;
                    
                    //jesli krawedz jest do samego siebie
                    if ( nd.getX()==n2.getX() && nd.getY()==n2.getY()) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setColor(currentEdge.color);                        
                        g.drawArc((int)nd.getX()-8, (int)nd.getY()-8, 16, 16, 70, 270);
                        drawArrow((Graphics2D)g,nd.getX()+4, nd.getY()-8,
                                                nd.getX()+8, nd.getY(),6f,5f);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_OFF);
                        
                        Rectangle2D edgeRect = new Rectangle2D.Float(nd.getX()-16,nd.getY()-16,15f,15f);
                        if ( m_lastMousePos!= null && edgeRect.contains(m_lastMousePos) ) {
                            m_lastEdgeOver = currentEdge;
                            //MainWindow.printToConsole("\n mouse over edge");
                        }
                        
                        if (m_lastEdgeOver == currentEdge) {
                            g.setColor(Color.BLUE);
                            g.fillRect((int)edgeRect.getMinX(), (int)edgeRect.getMinY(), 15,15);
                            g.setColor(Color.yellow);
                        }                        
                        else
                            g.setColor(Color.black);
                        g.drawString(""+currentEdge.value,(int)edgeRect.getMinX(),(int)edgeRect.getMinY()+12);
                        g.setColor(Color.black);
                        continue;
                    }
                    
                    //oblicz punkty przeciecia na obu wierzcholkach (ich prostokatach)
                    Rectangle rect = new Rectangle((int)n2.getX(),(int)n2.getY(),NODE_DIM_WIDTH, NODE_DIM_HEIGHT);
                    Rectangle rect2 = new Rectangle((int)nd.getX(),(int)nd.getY(),NODE_DIM_WIDTH, NODE_DIM_HEIGHT);
                    Line2D.Float line = new Line2D.Float(nd.getX()+15,
                    nd.getY()+15,
                    n2.getX()+15+Math.min(targetVertexCount*8,NODE_DIM_WIDTH-1),
                    n2.getY()+15+Math.min(targetVertexCount*8,NODE_DIM_HEIGHT-1));
                    if(0!=targetVertexCount)
                        System.out.println(""+targetVertexCount);
                    Point2D.Float pt = lineRectIntersection(rect, line);
                    Point2D.Float pt2 = lineRectIntersection(rect2, line);
                    
                    if (pt != null && pt2 != null) {
                        g.setColor(currentEdge.color);
                        drawArrow((Graphics2D)g,pt2.x, pt2.y, pt.x, pt.y,6f,5f);
                        
                        Point2D pnt = new Point2D.Float();
                        Point2D pnt2 = new Point2D.Float();
                        Point2D drawPnt = new Point2D.Float();
                        pnt.setLocation(pt2.x-pt.x,pt2.y-pt.y);
                        float mag = (float)Math.sqrt(pnt.getX()*pnt.getX()+pnt.getY()*pnt.getY());
                        pnt.setLocation(pnt.getX()/mag,pnt.getY()/mag);
                        pnt2.setLocation(pnt.getY(),-pnt.getX());
                        drawPnt.setLocation(pt.x+10*pnt.getX()+5*pnt2.getX(),
                        5+pt.y+10*pnt.getY()+5*pnt2.getX());
                        Rectangle2D edgeRect = new Rectangle2D.Float((float)drawPnt.getX()-2,(float)drawPnt.getY()-14,15f,15f);
                        if ( m_lastMousePos!= null && edgeRect.contains(m_lastMousePos) ) {
                            m_lastEdgeOver = currentEdge;
                            //MainWindow.printToConsole("\n mouse over edge");
                        }
                        
                        if (m_lastEdgeOver == currentEdge) {
                            g.setColor(Color.BLUE);
                            g.fillRect((int)edgeRect.getMinX(), (int)edgeRect.getMinY(), 15,15);
                            g.setColor(Color.yellow);
                        }
                        else
                            g.setColor(Color.black);
                        g.drawString(""+currentEdge.value,(int)drawPnt.getX(),(int)drawPnt.getY()-1);
                        g.setColor(Color.black);                        
                    }
                    else {
                        //tylko jeli nody zachodz na siebie
                    }
                    
                    //g.drawLine((int)nd.getX()+15,(int)nd.getY()+15, (int)n2.getX()+15,(int)n2.getY()+15);
                }
            }
        }
        
        if (m_graph!=null) {
            Iterator it = m_graph.vertices.iterator();
            while (it.hasNext()) {
                Vertex nd = (Vertex)it.next();
                
                if (nd == m_lastVertexOver)
                    g.setColor(Color.WHITE);
                else
                    if (nd == m_lastVertexClicked)
                        g.setColor(Color.LIGHT_GRAY);
                    else
                        g.setColor(nd.getCol());
                
                g.fillRect((int)nd.getX(),(int)nd.getY(),NODE_DIM_WIDTH, NODE_DIM_HEIGHT);
                g.setColor(Color.BLACK);
                g.drawRect((int)nd.getX(),(int)nd.getY(),NODE_DIM_WIDTH, NODE_DIM_HEIGHT);
                g.drawString(nd.toString(),(int)nd.getX()+1,(int)nd.getY()+11);
                g.drawString(nd.getVarsAsString(),(int)nd.getX()+1,(int)nd.getY()+22);
            }
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
    }
    
    
    public Point2D.Float lineRectIntersection(Rectangle rect, Line2D.Float line) {
        if (!rect.intersects(rect)) return null;
        Line2D.Float rlines[] = new Line2D.Float[4];
        rlines[0] = new Line2D.Float(rect.x,rect.y, rect.x+rect.width, rect.y);
        rlines[1] = new Line2D.Float(rect.x,rect.y, rect.x, rect.y+rect.height);
        rlines[2] = new Line2D.Float(rect.x,rect.y+rect.height, rect.x+rect.width, rect.y+rect.height);
        rlines[3] = new Line2D.Float(rect.x+rect.width,rect.y, rect.x+rect.width, rect.y+rect.height);
        
        Point2D.Float minp=null;
        Point2D.Float tmpp=null;
        float dist=9999.0f;
        for (int i=0; i<4; i++) {
            tmpp = lineInt(rlines[i], line);
            if (tmpp!=null) {
                float d = (float)line.getP1().distance(tmpp);
                if (d<dist) {
                    dist = d;
                    minp=tmpp;
                }
            }
        }
        return minp;
    }
    
    public Point2D.Float lineInt(Line2D.Float a,Line2D.Float b) {
        Point2D.Float diff1 = new Point2D.Float(b.x1-a.x1, b.y1-a.y1);
        Point2D.Float diff2 = new Point2D.Float(a.x1-b.x1, a.y1-b.y1);
        
        Point2D.Float d1 = new Point2D.Float(a.x2-a.x1, a.y2-a.y1);
        //float norm = (float)Math.sqrt(d1.x*d1.x+d1.y*d1.y);
        //d1.x /= norm;
        //d1.y /= norm;
        Point2D.Float d2 = new Point2D.Float(b.x2-b.x1, b.y2-b.y1);
        //norm = (float)Math.sqrt(d2.x*d2.x+d2.y*d2.y);
        //d2.x /= norm;
        //d2.y /= norm;
        
        Point2D.Float td1 = new Point2D.Float(d1.y, -d1.x);
        Point2D.Float td2 = new Point2D.Float(d2.y, -d2.x);
        
        float s = (diff1.x * td2.x + diff1.y * td2.y) / (d1.x*td2.x + d1.y*td2.y);
        float t = (diff2.x * td1.x + diff2.y * td1.y) / (d2.x*td1.x + d2.y*td1.y);
        
        if ( s<0 || s>1) return null;
        if ( t<0 || t>1) return null;
        
        Point2D.Float res = new Point2D.Float(a.x1 + d1.x*s, a.y1 + d1.y*s);
        return res;
    }
    
    public void mouseDragged(MouseEvent e) {
        if(m_lastVertexOver!=null) {
            m_lastVertexOver.setX(e.getPoint().x - m_mouseOffsetInVertex.x);
            m_lastVertexOver.setY(e.getPoint().y  - m_mouseOffsetInVertex.y);
            repaint();
        }
    }
    
    /**
     * Sprawdza czy kursor myszy nie znalaz si nad ktrym z wierzchokw albo
     * krawdzi.
     * @param e
     */
    public void mouseMoved(MouseEvent e) {
        if (m_graph==null) return;
        m_lastMousePos.x = e.getPoint().x;
        m_lastMousePos.y = e.getPoint().y;
        //najpierw sprawdz czy nie jest wskazywany ktorys z wierzcholkow
        Collection col = m_graph.getVerticies();
        Iterator it = col.iterator();
        Vertex vert;
        while(it.hasNext()) {
            vert = (Vertex)it.next();
            if (e.getPoint().x >= vert.getX() && e.getPoint().x <= vert.getX() + NODE_DIM_WIDTH &&
            e.getPoint().y >= vert.getY() && e.getPoint().y <= vert.getY() + NODE_DIM_HEIGHT) {
                m_lastVertexOver = vert;
                repaint();
                return;
            }
        }
        if (m_lastVertexOver != null) {
            m_lastVertexOver=null;
            repaint();
        }
    }
    
    public Vertex getLastVertexOver() {
        return m_lastVertexOver;
    }
    
    public void mouseClicked(MouseEvent e) {
        if ( e.getButton() == MouseEvent.BUTTON3)
            if ( m_lastVertexOver != null) {
                
                MainWindow.printToConsole("\n"+m_lastVertexOver);
                String str="";
                if (m_lastVertexOver.edges != null) {
                    str = " nodes : ";
                    for (int i=0; i< m_lastVertexOver.edges.length; i++)
                        str+=m_graph.findEdge( m_lastVertexOver.edges[i]).to+",";
                }
                MainWindow.printToConsole(str);
            }
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
        m_lastVertexClicked = m_lastVertexOver;
        if(m_lastVertexOver != null) {
            m_mouseOffsetInVertex.x = e.getPoint().x - (int)m_lastVertexClicked.getX();
            m_mouseOffsetInVertex.y = e.getPoint().y - (int)m_lastVertexClicked.getY();
        }
    }
    
    public void mouseReleased(MouseEvent e) {
        m_lastVertexClicked = m_lastVertexOver;
    }
    
    /**
     * Draws a line with an arrow head at its end.
     *
     * x1/y1 - Starting point
     * x2/y2 - End point
     * al - Arrowhead length
     * aw - Arrowhead width
     */
    void drawArrow(Graphics2D g, float x1, float y1, float x2, float y2,
    float al, float aw) {
        float x,y,length;
        Point2D start = new Point2D.Float(x1,y1);
        Point2D end = new Point2D.Float(x2,y2);
        Point2D base = new Point2D.Float();
        Point2D back_top = new Point2D.Float();
        Point2D back_bottom = new Point2D.Float();
        //   Compute length of line
        length = (float)Math.sqrt((x2-x1)*(x2-x1) + (y2-y1)*(y2-y1));
        //   Compute normalized line vector
        x = (x2-x1) / length;
        y = (y2-y1) / length;
        //   Compute points for arrow head
        base.setLocation(x2-x*al, y2-y*al);
        back_top.setLocation(base.getX() - aw*y, base.getY() + aw*x);
        back_bottom.setLocation(base.getX() + aw*y, base.getY() - aw*x);
        
        // Draw lines
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        g.draw(new Line2D.Float(start,end));
        //g.draw(new Line2D.Float(end,back_bottom));
        //g.draw(new Line2D.Float(end,back_top));
        
        g.fillPolygon(new int[]{(int)(back_bottom.getX()+0.5f),(int)(end.getX()+0.5f),(int)(back_top.getX()+0.5f)},
        new int[]{(int)(back_bottom.getY()+0.5f),(int)(end.getY()+0.5f),(int)(back_top.getY()+0.5f)},3);
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_OFF);
    }
    
    
}
