/*
 * Decompiled with CFR 0.152.
 */
package AGR.plugins;

import AGR.Graph;
import AGR.MainWindow;
import AGR.Plugin;
import AGR.Vertex;
import java.util.LinkedList;

public class Transpose
implements Plugin {
    Graph m_graph;
    LinkedList m_queue = new LinkedList();
    int m_stepCount;
    int m_currentStepCount;
    boolean m_finished = true;

    public void start(Graph graph, Vertex startVert) {
        this.m_graph = graph;
        this.m_finished = false;
        int[][] matRep = graph.getMatrixRepresentation();
        for (int y = 0; y < matRep.length; ++y) {
            for (int x = y; x < matRep[y].length; ++x) {
                int tmp = matRep[y][x];
                matRep[y][x] = matRep[x][y];
                matRep[x][y] = tmp;
            }
        }
        this.m_graph.applyNewMatrixRepresentation(matRep);
        this.m_finished = true;
        MainWindow.printToConsole("\nTransposition done");
    }

    public void makeStep() {
    }

    public String toString() {
        return "Transpose";
    }

    public void setStartStep() {
        this.m_finished = true;
    }

    public boolean isFinished() {
        return this.m_finished;
    }

    public void incStep() {
        ++this.m_stepCount;
    }

    public void decStep() {
        if (this.m_stepCount > 1) {
            --this.m_stepCount;
        }
    }

    public boolean canDoForward() {
        return false;
    }

    public boolean canDoBackward() {
        return false;
    }

    public boolean canPause() {
        return false;
    }
}

