/*
 * Decompiled with CFR 0.152.
 */
package AGR;

import AGR.Edge;
import AGR.Vertex;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class Graph
implements Serializable {
    float MAX_LENGTH = 200.0f;
    protected Collection vertices;
    protected Collection edges;

    public Graph() {
        this.vertices = new Vector();
        this.edges = new Vector();
    }

    public Graph(String filename) throws IOException {
        this.loadTxt(new File(filename));
    }

    public Graph(File file) throws IOException {
        this.loadTxt(file);
    }

    public int numberOfVerticies() {
        return this.vertices.size();
    }

    public Collection getVerticies() {
        return this.vertices;
    }

    public int addVertex(Vertex n) {
        n.setId(Vertex.getNextFreeId());
        this.vertices.add(n);
        return this.vertices.size() - 1;
    }

    public synchronized void removeVertex(Vertex v) {
        if (v.edges != null) {
            int[] cl_edges = (int[])v.edges.clone();
            for (int n = 0; n < cl_edges.length; ++n) {
                this.removeEdge(this.findEdge(cl_edges[n]));
            }
        }
        System.out.println("Edges 2 : " + this.edges.size());
        Iterator it = this.edges.iterator();
        while (it.hasNext()) {
            Edge eg = (Edge)it.next();
            if (eg.to != v.id) continue;
            Vertex vr = this.findVertex(eg.from);
            if (vr == null) {
                throw new Error("Null vertex found while removing vertex");
            }
            int[] newEdges = new int[vr.edges.length - 1];
            int i2 = 0;
            for (int i = 0; i < vr.edges.length; ++i) {
                if (vr.edges[i] == eg.getId()) continue;
                newEdges[i2++] = vr.edges[i];
            }
            vr.edges = newEdges;
            it.remove();
        }
        this.vertices.remove(v);
        this.repairAllVertexIds();
        System.out.println("Edges 2 : " + this.edges.size());
    }

    public void removeEdge(Edge n) {
        Vertex vr = this.findVertex(n.from);
        int[] newEdges = new int[vr.edges.length - 1];
        int i2 = 0;
        for (int i = 0; i < vr.edges.length; ++i) {
            if (vr.edges[i] == n.getId()) continue;
            newEdges[i2++] = vr.edges[i];
        }
        vr.edges = newEdges;
        this.edges.remove(n);
    }

    public int addEdge(Edge n) {
        this.edges.add(n);
        return n.getId();
    }

    public void save(String filename) {
        if (filename.length() == 0) {
            return;
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(filename);
            out = new ObjectOutputStream(fos);
            out.writeObject(this);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveAsGD0(String filename) throws IOException {
        this.binOutputGraph(new FileOutputStream(new File(filename)));
        String vars_fname = filename.substring(0, filename.lastIndexOf(".gd0"));
        this.saveVertexVars(new FileOutputStream(new File(vars_fname + ".vrs")));
    }

    public void saveVertexVars(OutputStream outs) {
        if (outs == null || this.vertices == null) {
            return;
        }
        PrintStream pstr = new PrintStream(outs);
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            String vr = nd.getVarsAsString();
            if (vr.length() == 0) {
                vr = ";";
            }
            pstr.print("" + nd.getId() + "\n" + vr + "\n");
        }
    }

    public void loadVertexVars(InputStream ins) throws IOException {
        if (ins == null || this.vertices == null) {
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(ins));
        String id;
        while ((id = r.readLine()) != null) {
            int vert_id = Integer.parseInt(id);
            Vertex vert = this.findVertex(vert_id);
            String vars = r.readLine();
            if (vars == null) {
                return;
            }
            vert.setVertexHashVars(vars);
        }
        return;
    }

    public int[] saveGD0ToArray() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.binOutputGraph(byteStream);
        byte[] barr = byteStream.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(barr));
        int[] iarr = new int[barr.length / 4];
        int pos = 0;
        while (true) {
            int k = 0;
            try {
                k = dis.readInt();
            }
            catch (EOFException e) {
                break;
            }
            iarr[pos++] = k;
        }
        return iarr;
    }

    public void loadGD0FromArray(int[] iarr) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream iStream = new DataOutputStream(byteStream);
        int pos = 0;
        while (pos < iarr.length) {
            try {
                iStream.writeInt(iarr[pos++]);
            }
            catch (EOFException e) {
                // empty catch block
                break;
            }
        }
        this.binLoad(new ByteArrayInputStream(byteStream.toByteArray()));
    }

    public static Graph loadObj(String filename) throws IOException {
        if (filename.length() == 0) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream in = null;
        Graph gr = null;
        try {
            fis = new FileInputStream(filename);
            in = new ObjectInputStream(fis);
            gr = (Graph)in.readObject();
            in.close();
            Iterator it = gr.vertices.iterator();
            while (it.hasNext()) {
                Vertex vert = (Vertex)it.next();
                Vertex.nextFreeId = Math.max(vert.id, Vertex.nextFreeId) + 1;
            }
            it = gr.edges.iterator();
            while (it.hasNext()) {
                Edge eg = (Edge)it.next();
                Edge.idCounter = Math.max(eg.id, Edge.idCounter) + 1;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return gr;
    }

    public void loadFromGD0(String filename) throws IOException {
        if (filename.length() == 0) {
            return;
        }
        this.binLoad(new FileInputStream(new File(filename)));
        String vars_fname = filename.substring(0, filename.lastIndexOf(".gd0"));
        try {
            this.loadVertexVars(new FileInputStream(new File(vars_fname + ".vrs")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void loadTxt(File file) throws IOException {
        if (file == null) {
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StreamTokenizer st = new StreamTokenizer(r);
        st.commentChar(35);
        this.vertices = new Vector();
        this.edges = new Vector();
        while (st.nextToken() != -1) {
            Vertex nd = new Vertex();
            nd.setId((int)st.nval);
            this.vertices.add(nd);
            nd.setX(250.0f + (float)Math.random() * 30.0f);
            nd.setY(250.0f + (float)Math.random() * 30.0f);
            st.nextToken();
            int edgCount = (int)st.nval;
            nd.edges = new int[edgCount];
            for (int i = 0; i < edgCount; ++i) {
                st.nextToken();
                nd.edges[i] = this.edges.size();
                this.edges.add(new Edge(nd.getId(), (int)st.nval));
            }
        }
    }

    public void outputGraph(OutputStream outs) {
        if (outs == null || this.vertices == null) {
            return;
        }
        PrintStream pstr = new PrintStream(outs);
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            pstr.println("" + nd.getId());
            if (nd.edges == null) continue;
            for (int k = 0; k < nd.edges.length; ++k) {
                Iterator it2 = this.vertices.iterator();
                Vertex nd2 = null;
                int count = this.findEdge((int)nd.edges[k]).to;
                nd2 = this.findVertex(count);
                pstr.println("    " + nd2.getId());
            }
        }
    }

    private void binLoad(InputStream ins) throws IOException {
        if (ins == null) {
            return;
        }
        DataInputStream r = new DataInputStream(ins);
        this.vertices = new Vector();
        this.edges = new Vector();
        int in = 0;
        boolean done = false;
        while (!done) {
            try {
                in = r.readInt();
            }
            catch (EOFException e) {
                done = true;
                continue;
            }
            Vertex nd = new Vertex();
            nd.setId(in);
            this.vertices.add(nd);
            nd.setX(250.0f + (float)Math.random() * 30.0f);
            nd.setY(250.0f + (float)Math.random() * 30.0f);
            try {
                in = r.readInt();
            }
            catch (EOFException e) {
                done = true;
                continue;
            }
            if (in == 0) continue;
            int edgCount = in;
            nd.edges = new int[edgCount];
            for (int i = 0; i < edgCount; ++i) {
                try {
                    in = r.readInt();
                }
                catch (EOFException e) {
                    done = true;
                }
                Edge eg = new Edge(nd.getId(), in);
                this.edges.add(eg);
                nd.edges[i] = eg.getId();
            }
        }
    }

    private void binOutputGraph(OutputStream out_stream) throws IOException {
        if (out_stream == null || this.vertices == null) {
            return;
        }
        DataOutputStream outs = new DataOutputStream(out_stream);
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            outs.writeInt(nd.getId());
            if (nd.edges == null) {
                outs.writeInt(0);
                continue;
            }
            outs.writeInt(nd.edges.length);
            for (int k = 0; k < nd.edges.length; ++k) {
                Iterator it2 = this.vertices.iterator();
                Vertex nd2 = null;
                int count = this.findEdge((int)nd.edges[k]).to;
                nd2 = this.findVertex(count);
                outs.writeInt(nd2.getId());
            }
        }
    }

    public Vertex findVertex(int n) {
        Iterator it = this.vertices.iterator();
        Vertex vert = null;
        while (it.hasNext()) {
            vert = (Vertex)it.next();
            if (vert.getId() != n) continue;
            return vert;
        }
        return null;
    }

    public int findVertexInd(int n) {
        Iterator it = this.vertices.iterator();
        Vertex vert = null;
        int ind = 0;
        while (it.hasNext()) {
            vert = (Vertex)it.next();
            if (vert.getId() == n) {
                return ind;
            }
            ++ind;
        }
        return 0;
    }

    public Vertex findVertexAtInd(int n) {
        Iterator it = this.vertices.iterator();
        Vertex vert = null;
        while (it.hasNext()) {
            vert = (Vertex)it.next();
            if (n == 0) {
                return vert;
            }
            --n;
        }
        return null;
    }

    public Edge findEdge(int n) {
        Iterator it = this.edges.iterator();
        Edge edg = null;
        while (it.hasNext()) {
            edg = (Edge)it.next();
            if (edg.getId() != n) continue;
            return edg;
        }
        return edg;
    }

    public void randomizePositions() {
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            nd.setX(250.0f + (float)Math.random() * 30.0f);
            nd.setY(250.0f + (float)Math.random() * 30.0f);
        }
    }

    public synchronized void relaxVerticePositions() {
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            if (nd.edges == null) continue;
            for (int e = 0; e < nd.edges.length; ++e) {
                float norm;
                float to_y;
                Iterator it2 = this.vertices.iterator();
                Vertex nd2 = null;
                int count = this.findEdge((int)nd.edges[e]).to;
                do {
                    nd2 = (Vertex)it2.next();
                } while (count-- != 0 && it2.hasNext());
                float to_x = nd.getX() - nd2.getX();
                double dist = Math.sqrt(to_x * to_x + (to_y = nd.getY() - nd2.getY()) * to_y);
                if (dist > (double)(this.MAX_LENGTH + 5.0f)) {
                    if ((norm = (float)Math.sqrt((to_x *= -1.0f) * to_x + (to_y *= -1.0f) * to_y)) == 0.0f) continue;
                    nd.setX(nd.getX() + to_x / norm);
                    nd.setY(nd.getY() + to_y / norm);
                    nd.setX(Math.max(nd.getX(), 0.0f));
                    nd.setY(Math.max(nd.getY(), 0.0f));
                    nd.setX(Math.min(nd.getX(), 2000.0f));
                    nd.setY(Math.min(nd.getY(), 2000.0f));
                    continue;
                }
                if (!(dist < (double)(this.MAX_LENGTH - 5.0f)) || (norm = (float)Math.sqrt(to_x * to_x + to_y * to_y)) == 0.0f) continue;
                nd.setX(nd.getX() + to_x / norm);
                nd.setY(nd.getY() + to_y / norm);
                nd.setX(Math.max(nd.getX(), 0.0f));
                nd.setY(Math.max(nd.getY(), 0.0f));
                nd.setX(Math.min(nd.getX(), 2000.0f));
                nd.setY(Math.min(nd.getY(), 2000.0f));
            }
        }
    }

    public int[][] getMatrixRepresentation() {
        int[][] matRep = new int[this.vertices.size()][this.vertices.size()];
        boolean ind1 = false;
        boolean ind2 = false;
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex vert = (Vertex)it.next();
            if (vert.edges == null) continue;
            for (int i = 0; i < vert.edges.length; ++i) {
                int v = this.findEdge((int)vert.edges[i]).to;
                Vertex vto = this.findVertex(v);
                int in = vert.getId();
                matRep[this.findVertexInd((int)in)][this.findVertexInd((int)v)] = 1;
            }
        }
        return matRep;
    }

    public void applyNewMatrixRepresentation(int[][] newMatRep) {
        int ind1 = 0;
        boolean ind2 = false;
        Iterator it = this.vertices.iterator();
        this.edges.clear();
        while (it.hasNext()) {
            Vertex vert = (Vertex)it.next();
            ind1 = this.findVertexInd(vert.getId());
            vert.edges = null;
            for (int i = 0; i < this.vertices.size(); ++i) {
                if (newMatRep[ind1][i] != 1) continue;
                int id = this.addEdge(new Edge(vert.getId(), this.findVertexAtInd(i).getId()));
                vert.addEdge(id);
            }
        }
    }

    public void repairAllVertexIds() {
        if (this.edges == null) {
            return;
        }
        Iterator it = this.vertices.iterator();
        Vertex.nextFreeId = 0;
        int id_num = 0;
        while (it.hasNext()) {
            Vertex curr = (Vertex)it.next();
            if (curr.getId() == id_num) {
                ++id_num;
                continue;
            }
            Iterator eg_it = this.edges.iterator();
            while (eg_it.hasNext()) {
                Edge eg = (Edge)eg_it.next();
                if (eg.from == curr.getId()) {
                    eg.from = id_num;
                }
                if (eg.to != curr.getId()) continue;
                eg.to = id_num;
            }
            curr.setId(id_num);
            ++id_num;
        }
        Vertex.nextFreeId = id_num;
    }

    public List[] getAdjacencyListRepresentation() {
        List[] listRep = new List[this.vertices.size()];
        boolean ind1 = false;
        boolean ind2 = false;
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex vert = (Vertex)it.next();
            if (vert.edges == null) continue;
            for (int i = 0; i < vert.edges.length; ++i) {
                int v = this.findEdge((int)vert.edges[i]).to;
                Vertex vto = this.findVertex(v);
                int in = vert.getId();
                if (listRep[this.findVertexInd(in)] == null) {
                    listRep[this.findVertexInd((int)in)] = new LinkedList();
                }
                listRep[this.findVertexInd(in)].add(vto);
            }
        }
        return listRep;
    }

    public void applyNewListRepresentation(List[] newRep) {
        boolean ind1 = false;
        boolean ind2 = false;
        this.vertices.clear();
        this.edges.clear();
        for (int i = 0; i < newRep.length; ++i) {
            Vertex vert = Graph.findVertexInAdjTable(newRep, i);
            vert.edges = null;
            this.vertices.add(vert);
            Iterator it = newRep[i].iterator();
            while (it.hasNext()) {
                Vertex vert2 = (Vertex)it.next();
                int id = this.addEdge(new Edge(vert.getId(), vert2.getId()));
                vert.addEdge(id);
            }
        }
    }

    public static Vertex findVertexInAdjTable(List[] adjTab, int id) {
        for (int n = 0; n < adjTab.length; ++n) {
            Iterator it = adjTab[n].iterator();
            while (it.hasNext()) {
                Vertex v = (Vertex)it.next();
                if (v.getId() != id) continue;
                return v;
            }
        }
        return null;
    }

    public void zeroVertexValues() {
        Iterator it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            v.setValue(0);
        }
    }

    public String[] getVertexVars() {
        String[] str = new String[this.vertices.size()];
        Iterator it = this.vertices.iterator();
        int cnt = 0;
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            str[cnt++] = v.getVarsAsString();
        }
        return str;
    }

    public void setVertexVars(String[] vars) {
        Iterator it = this.vertices.iterator();
        int cnt = 0;
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            v.setVertexHashVars(vars[cnt++]);
        }
    }

    static int[][][] textLoad(File file) throws IOException {
        if (file == null) {
            return null;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StreamTokenizer st = new StreamTokenizer(r);
        st.commentChar(35);
        st.nextToken();
        int lines = (int)st.nval;
        int[][][] ret = new int[lines][2][];
        for (int cur = 0; cur < lines && st.nextToken() != -1; ++cur) {
            int ints = (int)st.nval;
            ret[cur][0] = new int[ints];
            for (int i = 0; i < ints; ++i) {
                st.nextToken();
                ret[cur][0][i] = (int)st.nval;
            }
            ret[cur][1] = new int[1];
            st.nextToken();
            ret[cur][1][0] = (int)st.nval;
        }
        return ret;
    }

    static void textSave(File file, int[][][] tab) throws IOException {
        if (file == null) {
            return;
        }
        PrintStream pstr = new PrintStream(new FileOutputStream(file));
        pstr.println("" + tab.length);
        for (int i = 0; i < tab.length; ++i) {
            pstr.print("" + tab[i][0].length + " ");
            for (int n = 0; n < tab[i][0].length; ++n) {
                pstr.print("" + tab[i][0][n] + " ");
            }
            pstr.println("" + tab[i][1][0]);
        }
    }

    public static void main(String[] args) {
        Object tab = new int[][][]{new int[][]{{1, 2, 3}, {1}}, new int[][]{{1, 2, 3, 4}, {0}}, new int[][]{{1, 2, 3, 4, 5}, {0}}};
        try {
            Graph.textSave(new File("test.txt"), tab);
            tab = Graph.textLoad(new File("test.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

